/*
 * Decompiled with CFR 0.152.
 */
package net.jimmc.selfunzip;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ProgressMonitor;
import net.jimmc.jshortcut.JShellLink;

public class ZipSelfExtractor
extends JFrame {
    private String myClassName;
    private String jsClassName;
    static String MANIFEST = "META-INF/MANIFEST.MF";
    private File tmpDllFile;
    JTextField installDirField;
    private boolean addShortcutP;
    private boolean addMenuP;
    private boolean addClientP;
    private boolean autoStartP;
    private boolean showStatsP;
    private boolean debug;

    public static void main(String[] args) {
        ZipSelfExtractor zse = new ZipSelfExtractor();
        boolean ok = zse.doMain(args);
        System.exit(ok ? 0 : 1);
    }

    public boolean doMain(String[] args) {
        boolean bl = this.debug = System.getProperty("jraceman.install.debug") != null;
        if (System.getProperty("jraceman.install.pause") != null) {
            System.out.print("Installer paused for debug, press Enter to continue: ");
            try {
                System.in.read();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        String jarFileName = this.getJarFileName();
        return this.extract(jarFileName);
    }

    ZipSelfExtractor() {
    }

    private String getJarFileName() {
        this.myClassName = this.getClass().getName().replace('.', '/') + ".class";
        this.getClass().getClassLoader();
        URL urlJar = ClassLoader.getSystemResource(this.myClassName);
        String urlEncStr = urlJar.toString();
        String urlStr = URLDecoder.decode(urlEncStr);
        int from = "jar:file:".length();
        int to = urlStr.indexOf("!/");
        String jarFileName = urlStr.substring(from, to);
        if (this.debug) {
            System.out.println("myClassName=" + this.myClassName);
            System.out.println("urlEncStr=" + urlEncStr);
            System.out.println("urlStr=" + urlStr);
            System.out.println("jarFileName=" + jarFileName);
        }
        return jarFileName;
    }

    private boolean isWindows() {
        return File.separatorChar == '\\' || System.getProperty("jraceman.install.forceWindows") != null;
    }

    private String getProgramAndVersion(String filename) {
        String prog;
        int dx;
        String ext;
        int xx;
        if (this.debug) {
            System.out.println("programAndVersion from " + filename);
        }
        if ((xx = filename.lastIndexOf(46)) > 0 && (ext = filename.substring(xx + 1).toLowerCase()).equals("jar")) {
            filename = filename.substring(0, xx);
        }
        if ((dx = filename.indexOf(45)) < 0 && (dx = filename.indexOf(95)) > 0 && Character.isDigit(filename.charAt(dx - 1))) {
            --dx;
            while (dx > 0 && Character.isDigit(filename.charAt(dx - 1))) {
                --dx;
            }
            --dx;
        }
        if (dx < 0) {
            if (this.debug) {
                System.out.println("Can't figure out program and version");
                System.out.println("programAndVersion=" + filename);
            }
            return filename;
        }
        String ver = filename.substring(dx + 1).replace('_', '.');
        char ch = filename.charAt(dx);
        if (ch != '_' && ch != '-') {
            ++dx;
        }
        if ((prog = filename.substring(0, dx)).equalsIgnoreCase("jraceman") || prog.equalsIgnoreCase("JR")) {
            prog = "JRaceman";
        }
        String programAndVersion = prog + " " + ver;
        if (this.debug) {
            System.out.println("programAndVersion=" + programAndVersion);
        }
        return programAndVersion;
    }

    private String getVersionSuffix(String filename) {
        int vx;
        int sepx;
        if (this.debug) {
            System.out.println("getVersionSuffix from " + filename);
        }
        if ((sepx = filename.lastIndexOf(File.separatorChar)) > 0) {
            filename = filename.substring(sepx + 1);
        }
        if ((vx = filename.indexOf("-")) < 0) {
            vx = filename.indexOf("_");
        }
        if (vx > 0 && Character.isDigit(filename.charAt(vx - 1))) {
            --vx;
            while (vx > 0 && Character.isDigit(filename.charAt(vx - 1))) {
                --vx;
            }
            --vx;
        }
        if (vx < 0) {
            if (this.debug) {
                System.out.println("Can't figure version from " + filename);
                System.out.println("versionSuffix=X_X_X");
            }
            return "X_X_X";
        }
        String version = filename.substring(vx + 1);
        if ((vx = version.lastIndexOf(".")) > 0) {
            version = version.substring(0, vx);
        }
        if (this.debug) {
            System.out.println("versionSuffix=" + version);
        }
        return version;
    }

    File getInstallDir(String filename) {
        File installDirFile;
        String programAndVersion = this.getProgramAndVersion(filename);
        String installDirectory = this.isWindows() ? JShellLink.getDirectory("program_files") + "\\JRaceman" : System.getProperty("user.home") + File.separator + "jraceman";
        String versionSuffix = this.getVersionSuffix(filename);
        String msg = "This installer will create the directory\n   jraceman-" + versionSuffix + "\n" + "within the Install Directory you select.\n ";
        Box panel = Box.createVerticalBox();
        JTextArea introLabel = new JTextArea(msg);
        introLabel.setEditable(false);
        introLabel.setBackground(panel.getBackground());
        panel.add(introLabel);
        Box installDirBox = Box.createHorizontalBox();
        installDirBox.add(new JLabel("Install Directory: "));
        this.installDirField = new JTextField(30);
        this.installDirField.setText(installDirectory);
        installDirBox.add(this.installDirField);
        JButton browseButton = new JButton("Browse...");
        browseButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent ev) {
                String newInstallDir = ZipSelfExtractor.this.browseForInstallDirectory(ZipSelfExtractor.this.installDirField.getText());
                if (newInstallDir != null) {
                    ZipSelfExtractor.this.installDirField.setText(newInstallDir);
                }
            }
        });
        installDirBox.add(browseButton);
        panel.add(installDirBox);
        JCheckBox addShortcutField = null;
        JCheckBox addMenuField = null;
        JCheckBox addClientField = null;
        if (this.isWindows()) {
            String shortcutPrompt = "Add JRaceman shortcut on desktop";
            addShortcutField = new JCheckBox(shortcutPrompt, true);
            panel.add(this.hBox(addShortcutField));
            String menuPrompt = "Add JRaceman menu to Start Menu";
            addMenuField = new JCheckBox(menuPrompt, true);
            panel.add(this.hBox(addMenuField));
            String clientPrompt = "Add JRaceman client/server shortcuts/menus";
            addClientField = new JCheckBox(clientPrompt, true);
            panel.add(this.hBox(addClientField));
        }
        JCheckBox showStatsField = null;
        if (System.getProperty("UNJAR_SHOW_STATS") != null) {
            String statsPrompt = "Show extraction statistics on completion";
            showStatsField = new JCheckBox(statsPrompt, false);
            panel.add(this.hBox(showStatsField));
        }
        String autoStartPrompt = "Auto-start JRaceman after install";
        JCheckBox autoStartField = null;
        autoStartField = new JCheckBox(autoStartPrompt, true);
        panel.add(this.hBox(autoStartField));
        String title = "Installing " + programAndVersion;
        Object[] options = new Object[]{"Install", "Cancel"};
        int answer = JOptionPane.showOptionDialog(this, panel, title, -1, 3, null, options, options[0]);
        if (answer != 0) {
            return null;
        }
        installDirectory = this.installDirField.getText();
        if (addShortcutField != null) {
            this.addShortcutP = addShortcutField.isSelected();
        }
        if (addMenuField != null) {
            this.addMenuP = addMenuField.isSelected();
        }
        if (addClientField != null) {
            this.addClientP = addClientField.isSelected();
        }
        if (autoStartField != null) {
            this.autoStartP = autoStartField.isSelected();
        }
        if (showStatsField != null) {
            this.showStatsP = showStatsField.isSelected();
        }
        if (!(installDirFile = new File(installDirectory)).exists() && !installDirFile.mkdirs()) {
            msg = "Unable to create directory\n" + installDirectory;
            title = "Error Creating Directory";
            JOptionPane.showMessageDialog(this, msg, title, 0);
            return null;
        }
        return installDirFile;
    }

    private Box hBox(JComponent comp) {
        Box b = Box.createHorizontalBox();
        b.add(comp);
        b.add(Box.createGlue());
        return b;
    }

    private String browseForInstallDirectory(String defaultInstallDir) {
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(new File(defaultInstallDir));
        fc.setDialogType(0);
        fc.setDialogTitle("Select destination directory for extracting JRaceman");
        fc.setMultiSelectionEnabled(false);
        fc.setFileSelectionMode(1);
        if (fc.showDialog(this, "Select") != 0) {
            return null;
        }
        return fc.getSelectedFile().toString();
    }

    void setupNativeLibrary(String filename, ZipFile zf) throws IOException, FileNotFoundException {
        int nRead;
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (tmpDir == null) {
            System.out.println("No java.io.tmpdir set");
        }
        String versionSuffix = this.getVersionSuffix(filename);
        String dllName = "jraceman-" + versionSuffix + "/jshortcut.dll";
        ZipEntry ze = zf.getEntry(dllName);
        if (ze == null) {
            String eMsg = "Can't find entry in jar file for " + dllName;
            throw new RuntimeException(eMsg);
        }
        InputStream in = zf.getInputStream(ze);
        this.tmpDllFile = new File(tmpDir, "jshortcut.dll");
        FileOutputStream out = new FileOutputStream(this.tmpDllFile);
        byte[] buf = new byte[1024];
        while ((nRead = in.read(buf, 0, buf.length)) > 0) {
            out.write(buf, 0, nRead);
        }
        out.close();
        System.setProperty("JSHORTCUT_HOME", tmpDir);
        new JShellLink();
    }

    public boolean extract(String zipfile) {
        block40: {
            if (this.debug) {
                System.out.println("Trying to extract file " + zipfile);
            }
            File currentArchive = new File(zipfile);
            byte[] buf = new byte[1024];
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
            ProgressMonitor pm = null;
            boolean overwrite = false;
            boolean stopped = false;
            ZipFile zf = null;
            FileOutputStream out = null;
            InputStream in = null;
            try {
                String msg;
                zf = new ZipFile(currentArchive);
                if (this.isWindows()) {
                    this.setupNativeLibrary(zipfile, zf);
                }
                this.jsClassName = "net/jimmc/jshortcut/JShellName.class";
                String programAndVersion = this.getProgramAndVersion(currentArchive.getName());
                File outputDir = this.getInstallDir(currentArchive.getName());
                if (outputDir == null) {
                    return true;
                }
                int size = zf.size();
                int extracted = 0;
                int skipped = 0;
                int fullExtractionCount = size;
                String spaces = "                                                                                ";
                pm = new ProgressMonitor(this.getParent(), "Extracting files...", "starting" + spaces, 0, size - 4);
                pm.setMillisToDecideToPopup(0);
                pm.setMillisToPopup(0);
                Enumeration<? extends ZipEntry> entries = zf.entries();
                for (int i = 0; i < size; ++i) {
                    int nRead;
                    File parent;
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory()) {
                        --fullExtractionCount;
                        continue;
                    }
                    String pathname = entry.getName();
                    if (pathname.startsWith("net/jimmc/jshortcut") || pathname.startsWith("net/jimmc/selfunzip") || pathname.toUpperCase().equals(MANIFEST)) {
                        --fullExtractionCount;
                        continue;
                    }
                    pm.setProgress(i);
                    pm.setNote(pathname);
                    if (pm.isCanceled()) {
                        stopped = true;
                        break;
                    }
                    in = zf.getInputStream(entry);
                    File outFile = new File(outputDir, pathname);
                    Date archiveTime = new Date(entry.getTime());
                    if (!overwrite && outFile.exists()) {
                        Object[] options = new Object[]{"Yes", "Yes To All", "No", "Cancel"};
                        Date existTime = new Date(outFile.lastModified());
                        Long archiveLen = new Long(entry.getSize());
                        msg = "File name conflict: There is already a file with that name on the disk!\n\nFile name: " + outFile.getName() + "\nDestination: " + outFile.getPath() + "\nExisting file: " + formatter.format(existTime) + ",  " + outFile.length() + "Bytes" + "\nFile in archive:" + formatter.format(archiveTime) + ",  " + archiveLen + "Bytes" + "\n\nWould you like to overwrite the file?";
                        int result = JOptionPane.showOptionDialog(this, msg, "Warning", -1, 2, null, options, options[0]);
                        if (result == 3) {
                            stopped = true;
                            break;
                        }
                        if (result == 2) {
                            ++skipped;
                            continue;
                        }
                        if (result == 1) {
                            overwrite = true;
                        }
                    }
                    if ((parent = new File(outFile.getParent())) != null && !parent.exists()) {
                        parent.mkdirs();
                    }
                    out = new FileOutputStream(outFile);
                    while ((nRead = in.read(buf, 0, buf.length)) > 0) {
                        out.write(buf, 0, nRead);
                    }
                    ++extracted;
                    out.close();
                    outFile.setLastModified(archiveTime.getTime());
                }
                pm.close();
                zf.close();
                if (this.tmpDllFile != null) {
                    this.tmpDllFile.delete();
                }
                String stoppedMsg = "";
                if (stopped) {
                    stoppedMsg = "Stopped, extraction incomplete.\n \n";
                }
                String skippedMsg = "";
                if (skipped > 0) {
                    skippedMsg = " and skipped " + skipped + " file" + (skipped > 1 ? "s" : "");
                }
                String outOfMsg = "";
                if (extracted + skipped < fullExtractionCount) {
                    outOfMsg = " out of " + fullExtractionCount;
                }
                String currentArchiveName = currentArchive.getName();
                String version = this.getVersionSuffix(currentArchiveName);
                String targetDir = outputDir.getPath() + File.separator + "jraceman-" + version;
                String jarFileName = targetDir + File.separator + "jraceman.jar";
                String title = "Installed " + programAndVersion;
                msg = stoppedMsg + "Extracted " + extracted + " file" + (extracted != 1 ? "s" : "") + skippedMsg + outOfMsg + " from the\n" + zipfile + "\narchive into the\n" + targetDir + "\ndirectory.";
                File jarFile = new File(jarFileName);
                if (jarFile.exists()) {
                    msg = msg + "\n\nThe JRaceman executable JAR file is at\n" + jarFileName;
                }
                if (this.showStatsP || stopped) {
                    JOptionPane.showMessageDialog(this, msg, title, 1);
                }
                if (this.isWindows() && !stopped && jarFile.exists()) {
                    String serverBatName = targetDir + File.separator + "server.bat";
                    String clientBatName = targetDir + File.separator + "client.bat";
                    String shutdownBatName = targetDir + File.separator + "shutdown.bat";
                    if (this.addShortcutP) {
                        String desktopDir = JShellLink.getDirectory("desktop");
                        JShellLink link = new JShellLink();
                        link.setFolder(desktopDir);
                        link.setName("JRaceman");
                        link.setDescription(programAndVersion);
                        link.setPath(jarFileName);
                        link.save();
                        if (this.addClientP) {
                            link = new JShellLink();
                            link.setFolder(desktopDir);
                            link.setName("JRaceman Server");
                            link.setDescription(programAndVersion + " Server");
                            link.setPath(serverBatName);
                            link.save();
                            link = new JShellLink();
                            link.setFolder(desktopDir);
                            link.setName("JRaceman Client");
                            link.setDescription(programAndVersion + " Client");
                            link.setPath(clientBatName);
                            link.save();
                            link = new JShellLink();
                            link.setFolder(desktopDir);
                            link.setName("JRaceman Shutdown");
                            link.setDescription(programAndVersion + " Shutdown");
                            link.setPath(shutdownBatName);
                            link.save();
                        }
                    }
                    if (this.addMenuP) {
                        String programs = JShellLink.getDirectory("programs");
                        String jmenu = programs + "\\JRaceman";
                        File pf = new File(jmenu);
                        if (!pf.exists() && !pf.mkdir()) {
                            throw new RuntimeException("Can't create menu");
                        }
                        JShellLink link = new JShellLink();
                        link.setFolder(jmenu);
                        link.setName("JRaceman");
                        link.setDescription(programAndVersion);
                        link.setPath(jarFileName);
                        link.save();
                        if (this.addClientP) {
                            link = new JShellLink();
                            link.setFolder(jmenu);
                            link.setName("JRaceman Server");
                            link.setDescription(programAndVersion + " Server");
                            link.setPath(serverBatName);
                            link.save();
                            link = new JShellLink();
                            link.setFolder(jmenu);
                            link.setName("JRaceman Client");
                            link.setDescription(programAndVersion + " Client");
                            link.setPath(clientBatName);
                            link.save();
                            link = new JShellLink();
                            link.setFolder(jmenu);
                            link.setName("JRaceman Shutdown");
                            link.setDescription(programAndVersion + " Shutdown");
                            link.setPath(shutdownBatName);
                            link.save();
                        }
                    }
                }
                if (!this.autoStartP || stopped || !jarFile.exists()) break block40;
                pm = new ProgressMonitor(this.getParent(), "Starting JRaceman, please wait...", " ", 0, 100);
                pm.setMillisToDecideToPopup(0);
                pm.setMillisToPopup(0);
                pm.setProgress(1);
                pm.setNote(" ");
                this.startJar(jarFileName);
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                pm.close();
            }
            catch (Exception e) {
                if (System.getProperty("jraceman.install.debug") != null) {
                    e.printStackTrace(System.out);
                } else {
                    System.out.println(e);
                }
                if (zf != null) {
                    try {
                        zf.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                return false;
            }
        }
        return true;
    }

    public void startJar(String jar) {
        Runtime rt = Runtime.getRuntime();
        String cmd = this.isWindows() ? "\"" + this.getJavawProg() + "\" -jar \"" + jar + "\"" : this.getJavaProg() + " -jar " + jar;
        try {
            rt.exec(cmd);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Can't run " + cmd, "Error Running Java", 0);
        }
    }

    public String getJavaProg() {
        String sep = File.separator;
        return System.getProperty("java.home") + sep + "bin" + sep + "java";
    }

    public String getJavawProg() {
        String sep = File.separator;
        return System.getProperty("java.home") + sep + "bin" + sep + "javaw";
    }
}

